﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
//#include "gameFunctions/getPathValue.as"
//#include "gameProgram/parseVariablePaths.as"
#include "gameFunctions/nestedEval.as"
	// evalPath
	// resolveContainer
	// getImpliedValue
define_while = function( command_obj )
{
	command_obj.run = function( thisCommand_obj )
	{
		if(_this.scriptInterruptCheck())
		{// if:  script has not been interrupted
			var conditionResult = thisCommand_obj.getConditionResult( thisCommand_obj );
			var condition = thisCommand_obj.data.condition;
			if(TRACE_SCRIPT)
				trace("while: "+condition[0]+" "+condition[1]+" "+condition[2]+"  result: "+conditionResult);
			if(_this._name.length==0){
				// clear all of this sprite's timeouts
				for (var s in _this.scripts)											// for: each script
					if(_this.scripts[s].timeoutID!=undefined)				// if:  this script has a timeout ID stored
						clearTimeout( _this.scripts[s].timeoutID );		// clear the timeout
				thisCommand_obj = null;		// stop the entire script
				conditionResult = true;		// stop the loop
			}
			
			if(conditionResult==true)
			{// if:  condition is true  &  there are commands inside the "if" statement
				// detect when inner script finishes and run everything again
				thisCommand_obj.script.done = function(){
					//thisCommand_obj.run( thisCommand_obj );
					var waitId = setTimeout( thisCommand_obj.run, 1, thisCommand_obj );
					thisCommand_obj.storeTimeout( waitId );
				}// done()
				
				if(thisCommand_obj.script.length>0){		// script has commands
					thisCommand_obj.script.runEvent(0);
				}else{																	// script is empty
					// if there are no commands, wait for 1 frame, then check again
					var waitId = setTimeout( thisCommand_obj.run, 33, thisCommand_obj );
					thisCommand_obj.storeTimeout( waitId );
				}
			}// if:  condition is true
			else
			{// if:  condition is false
				thisCommand_obj.nextEvent();		// skip this command and continue the script
			}// if:  condition is false
		}// if:  script has not been interrupted
	}// run()
	
	
	
	
	
	command_obj.getConditionResult = function( thisCommand_obj )
	{
		var data = thisCommand_obj.data;
		
		// resolve target variable
		// parse any embedded variable paths
		var target_str = nestedEval( data.condition[0], "RAM", "_this" );
		var target = evalPath( target_str, "RAM", "_this" );
		//var target = getImpliedValue( target );		// convert string to appropriate datatype if neccessary
		
		// resolve value
		var thisValue = getImpliedValue(data.condition[2]);		// convert string to appropriate datatype if neccessary
		
		// parse any embedded variable paths
		thisValue = nestedEval( thisValue, "RAM", "_this" );
		var value = getImpliedValue( thisValue );
		
		
		// test the condition
		var conditionResult = false;
		switch(data.condition[1])
		{
			case "=":
				var conditionResult = (target == value);
			break;
			case "!=":
				var conditionResult = (target != value);
			break;
			case ">":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target > value);
			break;
			case ">=":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target >= value);
			break;
			case "<":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target < value);
			break;
			case "<=":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target <= value);
			break;
		}// switch:  operator
		
	//	trace("\t condition:  "+data.condition[0]+" "+data.condition[1]+" "+data.condition[2]+"  ("+conditionResult+")");
		return conditionResult;
	}// getConditionResult()
}// define_while()